IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_NF_ENT_IT_ESTORNO_DELETE]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_NF_ENT_IT_ESTORNO_DELETE]
GO 

CREATE PROCEDURE P_EST_NF_ENT_IT_ESTORNO_DELETE (@CD_EMP INT, @CD_FILIAL INT, @CD_NF INT, @CD_PROD INT, @CD_USU INT=0)
WITH ENCRYPTION
AS
BEGIN TRY 

	INSERT INTO EST_NF_ENT_IT_ESTORNO(CD_EMP,	CD_FILIAL,	NR_NF,	CD_FORN,	DT_EMI_NF,	DT_ENT,	CD_MOV_OP,
										DT_CAD,	CD_PROD,	SEQ_ITEM,	DS_PROD,	VLR_IT,	QT_IT,	VLR_ICMS_IT,
										ALIQ_ICMS,	CD_TRIB,	UN,	PERC_IPI,	VLR_PRC_CUSTO,	VLR_BASE_ICMS,	VLR_ICMS_SUBS,
										VLR_BASE_SUBS,	VLR_PRC_CUSTO_ANT,	CD_NT_OP,	VLR_IPI,	PERC_DESC,	VLR_DESC,	VLR_ISENTO,
										VLR_OUTROS,	VLR_TOT_IT,	PERC_IVA,	QT_EMB,	VLR_FRETE_IT,	PIS_COFINS,	PERC_DESC_FINAN,	PERC_REDU_BASE_SUBS,
										PERC_REDU_BASE_ICMS,	VLR_PROD_FRETE,	LISTA_PROD,	VLR_BASE_PIS,	VLR_PIS,	PERC_ALIQ_PIS,	VLR_BASE_COFINS,
										VLR_COFINS,	PERC_ALIQ_COFINS,	VLR_BASE_ICMS_RET,	VLR_ICMS_RET,	VLR_OUTRAS_DESPESAS,	VLR_PROD_PMC,	CD_SIT_OPERA_SIMPLES_NACIO,
										MODALI_BASE_ICMS_SUBST,	MODALI_BASE_ICMS,	VLR_CRED_BASE_SN,	VLR_CRED_ICMS_SN,	PIS_COFINS_RECALCULADO,
										CST_PIS,	CST_COFINS,	VLR_IMPOSTO_REA,	PERC_DESC_COMERCIAL,	ALIQ_ICMS_INTERNO,	TP_PROD,	CD_USU_LIBEROU_VALIDADE_LOTE,
										FLAG_N_GERAR_DAR,	TIPO_TRIBUTACAO_PIS_COFINS,	VLR_CUSTO_MD,	FLAG_EXCECAO_PIS_COFINS,	
										SIGLA_EXCECAO_PIS_COFINS,	VLR_CUSTO_ANT_RECALC,
										XPED_IT,	N_ITEM_PED,	FLAG_PROD_CESTA_BASICA,	VLR_DESC_FINAN,	VLR_CUSTO_GER,	
										VLR_CUSTO_GERENCIAL_TRANSF,	FLAG_ICMS_RETIDO_CALCULADO,
										VLR_BASE_ICMS_OP,	VLR_ICMS_OP,	VLR_CUSTO_SEM_ST,	PRZ_DESC_FIN,	PERC_ICMS_OP,	
										PERC_IVA_RET,	PERC_ICMS_RET,	VLR_RESSARCIMENTO_ICMS,
										IND_TOTAL,	VLR_CUSTO_ACERTO,	CD_USU,
										TP_MOV,DEST_ORIG,ATU_EST,CALC_CUSTO_MEDIO,FLAG_CUSTO_ZERO_ENT,
										CD_TRIB_FC,RZ_FORN,CGC_CPF)
	SELECT
		IT.CD_EMP,
		IT.CD_FILIAL,
		E.NR_NF,
		E.CD_FORN,
		E.DT_EMI_NF,
		IT.DT_ENT,
		E.CD_NT_MOV,
		GETDATE(),
		ISNULL(IT.CD_PROD,0),
		ISNULL(IT.SEQ_ITEM,0),
		ISNULL(IT.DS_PROD,''),
		ISNULL(IT.VLR_IT,0),
		ISNULL(IT.QT_IT,0),
		ISNULL(IT.VLR_ICMS_IT,0),
		ISNULL(IT.ALIQ_ICMS,0),
		ISNULL(IT.CD_TRIB,0),
		ISNULL(IT.UN,''),
		ISNULL(IT.PERC_IPI,0),
		ISNULL(IT.VLR_PRC_CUSTO,0),
		ISNULL(IT.VLR_BASE_ICMS,0),
		ISNULL(IT.VLR_ICMS_SUBS,0),
		ISNULL(IT.VLR_BASE_SUBS,0),
		ISNULL(IT.VLR_PRC_CUSTO_ANT,0),
		ISNULL(IT.CD_NT_OP,0),
		ISNULL(IT.VLR_IPI,0),
		ISNULL(IT.PERC_DESC,0),
		ISNULL(IT.VLR_DESC,0),
		ISNULL(IT.VLR_ISENTO,0),
		ISNULL(IT.VLR_OUTROS,0),
		ISNULL(IT.VLR_TOT_IT,0),
		ISNULL(IT.PERC_IVA,0),
		ISNULL(IT.QT_EMB,0),
		ISNULL(IT.VLR_FRETE_IT,0),
		ISNULL(IT.PIS_COFINS,0),
		ISNULL(IT.PERC_DESC_FINAN,0),
		ISNULL(IT.PERC_REDU_BASE_SUBS,0),
		ISNULL(IT.PERC_REDU_BASE_ICMS,0),
		ISNULL(IT.VLR_PROD_FRETE,0),
		ISNULL(IT.LISTA_PROD,0),
		ISNULL(IT.VLR_BASE_PIS,0),
		ISNULL(IT.VLR_PIS,0),
		ISNULL(IT.PERC_ALIQ_PIS,0),
		ISNULL(IT.VLR_BASE_COFINS,0),
		ISNULL(IT.VLR_COFINS,0),
		ISNULL(IT.PERC_ALIQ_COFINS,0),
		ISNULL(IT.VLR_BASE_ICMS_RET,0),
		ISNULL(IT.VLR_ICMS_RET,0),
		ISNULL(IT.VLR_OUTRAS_DESPESAS,0),
		ISNULL(IT.VLR_PROD_PMC,0),
		ISNULL(IT.CD_SIT_OPERA_SIMPLES_NACIO,0),
		ISNULL(IT.MODALI_BASE_ICMS_SUBST,0),
		ISNULL(IT.MODALI_BASE_ICMS,0),
		ISNULL(IT.VLR_CRED_BASE_SN,0),
		ISNULL(IT.VLR_CRED_ICMS_SN,0),
		ISNULL(IT.PIS_COFINS_RECALCULADO,0),
		ISNULL(IT.CST_PIS,0),
		ISNULL(IT.CST_COFINS,0),
		ISNULL(IT.VLR_IMPOSTO_REA,0),
		ISNULL(IT.PERC_DESC_COMERCIAL,0),
		ISNULL(IT.ALIQ_ICMS_INTERNO,0),
		ISNULL(IT.TP_PROD,0),
		ISNULL(IT.CD_USU_LIBEROU_VALIDADE_LOTE,0),
		ISNULL(IT.FLAG_N_GERAR_DAR,0),
		ISNULL(IT.TIPO_TRIBUTACAO_PIS_COFINS,0),
		ISNULL(IT.VLR_CUSTO_MD,0),
		ISNULL(IT.FLAG_EXCECAO_PIS_COFINS,0),
		ISNULL(IT.SIGLA_EXCECAO_PIS_COFINS,''),
		ISNULL(IT.VLR_CUSTO_ANT_RECALC,0),
		ISNULL(IT.XPED_IT,0),
		ISNULL(IT.N_ITEM_PED,0),
		ISNULL(IT.FLAG_PROD_CESTA_BASICA,0),
		ISNULL(IT.VLR_DESC_FINAN,0),
		ISNULL(IT.VLR_CUSTO_GER,0),
		ISNULL(IT.VLR_CUSTO_GERENCIAL_TRANSF,0),
		ISNULL(IT.FLAG_ICMS_RETIDO_CALCULADO,0),
		ISNULL(IT.VLR_BASE_ICMS_OP,0),
		ISNULL(IT.VLR_ICMS_OP,0),
		ISNULL(IT.VLR_CUSTO_SEM_ST,0),
		ISNULL(IT.PRZ_DESC_FIN,0),
		ISNULL(IT.PERC_ICMS_OP,0),
		ISNULL(IT.PERC_IVA_RET,0),
		ISNULL(IT.PERC_ICMS_RET,0),
		ISNULL(IT.VLR_RESSARCIMENTO_ICMS,0),
		ISNULL(IT.IND_TOTAL,0),
		ISNULL(IT.VLR_CUSTO_ACERTO,0),
		CASE WHEN @CD_USU >0 THEN @CD_USU
			ELSE ISNULL(E.CD_USU,0) END CD_USU, 
		O.TP_MOV,
		O.DEST_ORIG,
		O.ATU_EST,
		O.CALC_CUSTO_MEDIO,
		O.FLAG_CUSTO_ZERO_ENT, 
		T.CD_TRIB_FC,
		P.RAZAO_SOCIAL_PESSOA RZ_FORN,
		P.CGC_CPF  
	FROM	
		EST_NF_ENT_IT IT 
		INNER JOIN EST_NF_ENT E ON
		IT.CD_EMP	 = E.CD_EMP AND
		IT.CD_FILIAL = E.CD_FILIAL AND
		IT.CD_NF	 = E.CD_NF 

		INNER JOIN GLB_MOV_OP O  ON 
		E.CD_NT_MOV = O.CD_MOV_OP
 
		INNER JOIN EST_TRIB T  ON
		IT.CD_TRIB = T.CD_TRIB  
		CROSS APPLY dbo.UFD_GLB_PESSOA (e.CD_FORN, O.DEST_ORIG) P 

	WHERE
		E.CD_EMP		= @CD_EMP
		AND E.CD_FILIAL	= @CD_FILIAL
		AND E.CD_NF		= @CD_NF
		AND CASE WHEN @CD_PROD > 0 THEN IT.CD_PROD
				ELSE @CD_PROD END = @CD_PROD; 
			
END TRY
BEGIN CATCH
	IF @@NESTLEVEL > 0  ROLLBACK TRANSACTION;----------------------------------------------------------------------------------
	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;
END CATCH